#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_TransfusionReactionReport : BaseTest 
	{
		#region Variables

		private DateTime _startDate;
		private DateTime _endDate;

		private TransfusionReactionReport _transfusionReactionReport;

		#endregion

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();
			//
			// Set start date to a bit over a year ago
			this._startDate = DAL.VbecsDateTime.GetDivisionCurrentDateTime(UnitTestConfig.TestDivisionCode).Subtract(new TimeSpan(377, 0, 0, 0));
			this._endDate = DAL.VbecsDateTime.GetDivisionCurrentDateTime(UnitTestConfig.TestDivisionCode);
			//
			this._transfusionReactionReport = new TransfusionReactionReport();
		}
		
		// >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

		[Test]
		public void GetReportData_Summary_Pass()
		{
			this._transfusionReactionReport.StartDate = this._startDate;
			this._transfusionReactionReport.EndDate = this._endDate;
			this._transfusionReactionReport.DetailedReport = false;
			this._transfusionReactionReport.IsMultiDivisional = false;
			DataSet reportData = this._transfusionReactionReport.GetReportData();
			Assert.IsTrue(reportData.Tables.Count > 0 && reportData.Tables[0].Rows.Count > 0);
		}

		[Test]
		public void GetReportData_Summary_Multi_Divisional_Pass()
		{
			this._transfusionReactionReport.StartDate = this._startDate;
			this._transfusionReactionReport.EndDate = this._endDate;
			this._transfusionReactionReport.DetailedReport = false;
			this._transfusionReactionReport.IsMultiDivisional = true;
			DataSet reportData = this._transfusionReactionReport.GetReportData();
			Assert.IsTrue(reportData.Tables.Count > 0 && reportData.Tables[0].Rows.Count > 0);
		}

		[Test]
		public void GetReportData_Detailed_Pass()
		{
			this._transfusionReactionReport.StartDate = this._startDate;
			this._transfusionReactionReport.EndDate = this._endDate;
			this._transfusionReactionReport.DetailedReport = true;
			this._transfusionReactionReport.IsMultiDivisional = false;
			DataSet reportData = this._transfusionReactionReport.GetReportData();
			Assert.IsTrue(reportData.Tables.Count > 0 && reportData.Tables[0].Rows.Count > 0);
		}

		[Test]
		public void GetReportData_Detailed_Multi_Divisional_Pass()
		{
			this._transfusionReactionReport.StartDate = this._startDate;
			this._transfusionReactionReport.EndDate = this._endDate;
			this._transfusionReactionReport.DetailedReport = true;
			this._transfusionReactionReport.IsMultiDivisional = true;
			DataSet reportData = this._transfusionReactionReport.GetReportData();
			Assert.IsTrue(reportData.Tables.Count > 0 && reportData.Tables[0].Rows.Count > 0);
		}
		
		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetReportData_Fail()
		{
			this._transfusionReactionReport.StartDate = DateTime.MinValue;
			this._transfusionReactionReport.EndDate = DateTime.MinValue;
			this._transfusionReactionReport.DetailedReport = true;
			this._transfusionReactionReport.IsMultiDivisional = true;
			DataSet reportData = this._transfusionReactionReport.GetReportData();
			Assert.IsTrue(reportData.Tables.Count > 0 && reportData.Tables[0].Rows.Count > 0);
		}
		// >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

		[Test]
		public void GetReportCriteria_Pass()
		{
			_transfusionReactionReport.IsMultiDivisional=true;
			_transfusionReactionReport.DetailedReport=true;
			_transfusionReactionReport.StartDate=DateTime.Today.AddYears(-1);
			_transfusionReactionReport.StartDate=DateTime.Today;
			_transfusionReactionReport.PrintedBy=Common.LogonUser.LogonUserName;
			
			string reportCriteria = this._transfusionReactionReport.GetReportCriteria();
			
			Assert.IsTrue(reportCriteria != null && !reportCriteria.Equals(string.Empty));
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReportCriteria_Fail()
		{
		}
		
	/*	[Test]
		public void GenerateReport_Summary_Pass()
		{
			_transfusionReactionReport.IsMultiDivisional=false;
			_transfusionReactionReport.DetailedReport=false;
			_transfusionReactionReport.StartDate=DateTime.Today.AddYears(-1);
			_transfusionReactionReport.StartDate=DateTime.Today;
			_transfusionReactionReport.PrintedBy=Common.LogonUser.LogonUserName;

			Assert.IsNotNull( _transfusionReactionReport.GenerateReport(Common.LogonUser.LogonUserName) );
		}

		[Test]
		public void GenerateReport_Detailed_Pass()
		{
			_transfusionReactionReport.IsMultiDivisional=false;
			_transfusionReactionReport.DetailedReport=true;
			_transfusionReactionReport.StartDate=DateTime.Today.AddYears(-1);
			_transfusionReactionReport.StartDate=DateTime.Today;
			_transfusionReactionReport.PrintedBy=Common.LogonUser.LogonUserName;

			Assert.IsNotNull( _transfusionReactionReport.GenerateReport(Common.LogonUser.LogonUserName) );
		}

		[Test]
		public void GenerateReport_MultiDivisional_Summary_Pass()
		{
			_transfusionReactionReport.IsMultiDivisional=true;
			_transfusionReactionReport.DetailedReport=false;
			_transfusionReactionReport.StartDate=DateTime.Today.AddYears(-1);
			_transfusionReactionReport.StartDate=DateTime.Today;
			_transfusionReactionReport.PrintedBy=Common.LogonUser.LogonUserName;

			Assert.IsNotNull( _transfusionReactionReport.GenerateReport(Common.LogonUser.LogonUserName) );
		}

		[Test]
		public void GenerateReport_MultiDivisional_Detailed_Pass()
		{
			_transfusionReactionReport.IsMultiDivisional=true;
			_transfusionReactionReport.DetailedReport=true;
			_transfusionReactionReport.StartDate=DateTime.Today.AddYears(-1);
			_transfusionReactionReport.StartDate=DateTime.Today;
			_transfusionReactionReport.PrintedBy=Common.LogonUser.LogonUserName;

			Assert.IsNotNull( _transfusionReactionReport.GenerateReport(Common.LogonUser.LogonUserName) );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GenerateReport_Fail()
		{
		}
    */
		[Test]
		public void DetailedReport_Pass()
		{
			this._transfusionReactionReport.DetailedReport = true;
			Assert.AreEqual(this._transfusionReactionReport.DetailedReport, true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DetailedReport_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
			//Sends report directly to the printer
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail()
		{
			//Sends report directly to the printer
		}
 
		[Test]
		public void Ctor_Pass()
		{
			BOL.TransfusionReactionReport trp = new TransfusionReactionReport();
			//
			Assert.IsNotNull( trp );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}
	}
}
#endif
